using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Numerics;
using System.IO;

namespace ConsoleApp2
{
    class Program
    {
        static void EratostenovoSito(ref long[] primes)
        {
            const long n = 10000001;
            bool[] prime = new bool[n];
            for (long i = 2; i < n; i++)
                prime[i] = true;
            int i1 = 1;
            primes[0] = 2;
            for (long i = 4; i < n; i += 2)
            {
                prime[i] = false;
            }
            for (long i = 3; i < n; i += 2)
            {
                if(prime[i])
                {
                    primes[i1++] = i;
                    for (long j = i * i; j < n; j += i)
                        prime[j] = false;
                }
            }    
        }
        static void Main(string[] args)
        {
            long[] pr = new long[664579];
            EratostenovoSito(ref pr);
            int q = int.Parse(Console.ReadLine());
            while(q-->0)
            {
                long n = long.Parse(Console.ReadLine());
                int pos1 = Array.BinarySearch(pr, 0, pr.Length, n / 2);
                int pos2 = Array.BinarySearch(pr, 0, pr.Length, n);
                if(pos1<0)
                {
                    pos1 = ~pos1;
                    pos1--;
                }
                if (pos2 < 0)
                {
                    pos2 = ~pos2;
                    pos2--;
                }
                Console.WriteLine(n-1-(pos2-pos1));
            }
        }
    }
}